import { ComponentEvent } from "@egjs/component";
import { Observer } from "./Observer";
import { ReactiveSubscribe } from "./ReactiveSubscribe";
declare type AnyFunction = (...args: any[]) => any;
declare type NoArguments = undefined | null | void | never;
declare type EventKey<T extends Record<string, any>> = string & keyof T;
declare type UnknwonToAnyArray<Arr> = unknown[] extends Arr ? any[] : Arr;
export declare type ReactiveEventCallback<T extends Record<string, any>, K extends EventKey<T>> = T[K] extends NoArguments ? () => any : T[K] extends AnyFunction ? T[K] : T[K] extends ComponentEvent<infer PROPS> ? (event: ComponentEvent<PROPS, K>) => any : (event: T[K]) => any;
export declare type ReactiveEventParameters<Events extends Record<string, any>, EventName extends EventKey<Events>> = UnknwonToAnyArray<Parameters<ReactiveEventCallback<Events, EventName>>>;
export declare type ReactiveMethods<Instance, Names extends keyof Instance> = {
    [key in Names]: Instance[key];
};
export interface GetReactiveValue {
    <Type>(observer: Observer<Type>): Type;
    <Inst extends ReactiveSubscribe<object>, Name = (Inst extends ReactiveSubscribe<infer State> ? keyof State : unknown)>(inst: Inst, name: any): Name;
}
export {};
