/*
Copyright (c) NAVER Crop.
name: @cfcs/core
license: MIT
author: NAVER Crop.
repository: https://github.com/naver/cfcs
version: 0.0.6
*/
import Component from '@egjs/component';

/**
 * cfcs
 * Copyright (c) 2022-present NAVER Corp.
 * MIT license
 */
function keys(obj) {
  return Object.keys(obj);
}
function camelize(str) {
  return str.replace(/[\s-_]([a-z])/g, function (all, letter) {
    return letter.toUpperCase();
  });
}
function isString(val) {
  return typeof val === "string";
}
function isObject(val) {
  return typeof val === "object";
}
function isFunction(val) {
  return typeof val === "function";
}

function findTarget(target) {
  var el;

  if (!target) {
    return null;
  }

  if (isString(target)) {
    el = document.querySelector(target);
  } else if (target instanceof Element) {
    el = target;
  } else if ("value" in target || "current" in target) {
    el = target.value || target.current;
  }

  return el;
}
function withClassMethods(methods) {
  return function (prototype, memberName) {
    methods.forEach(function (name) {
      if (name in prototype) {
        return;
      }

      prototype[name] = function () {
        var _a;

        var args = [];

        for (var _i = 0; _i < arguments.length; _i++) {
          args[_i] = arguments[_i];
        }

        var result = (_a = this[memberName])[name].apply(_a, args); // fix `this` type to return your own `class` instance to the instance using the decorator.


        if (result === this[memberName]) {
          return this;
        } else {
          return result;
        }
      };
    });
  };
}

var OBSERVERS_PATH = "__observers__";

var Observer =
/*#__PURE__*/
function () {
  function Observer(value) {
    this._emitter = new Component();
    this._current = value;
  }

  var __proto = Observer.prototype;
  Object.defineProperty(__proto, "current", {
    get: function () {
      return this._current;
    },
    set: function (value) {
      var isUpdate = value !== this._current;
      this._current = value;

      if (isUpdate) {
        this._emitter.trigger("update", value);
      }
    },
    enumerable: false,
    configurable: true
  });

  __proto.subscribe = function (callback) {
    this._emitter.on("update", callback);
  };

  __proto.unsubscribe = function (callback) {
    this._emitter.off("update", callback);
  };

  return Observer;
}();

function withReactiveMethods(ref, methods) {
  var obj = {};

  if (!methods) {
    return obj;
  }

  methods.forEach(function (name) {
    obj[name] = function () {
      var args = [];

      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }

      var current = ref.current || ref.value;
      return current[name].apply(current, args);
    };
  });
  return obj;
}
function observe(defaultValue) {
  return new Observer(defaultValue);
}
function defineObservers(instance) {
  var observers = {};
  Object.defineProperty(instance, OBSERVERS_PATH, {
    get: function () {
      return observers;
    }
  });
  return observers;
}
function getObservers(instance) {
  if (!instance[OBSERVERS_PATH]) {
    defineObservers(instance);
  }

  return instance[OBSERVERS_PATH];
}
function getObserver(instance, name, defaultValue) {
  var observers = getObservers(instance);

  if (!observers[name]) {
    observers[name] = observe(defaultValue);
  }

  return observers[name];
}
function setObserver(instance, name, observer) {
  var observers = getObservers(instance);
  observers[name] = observer;
}
function isObserver(val) {
  return val && isObject(val) && "current" in val && "subscribe" in val && "unsubscribe" in val;
}

function Reactive(name) {
  return function (prototype, memberName) {
    var publicName = name || memberName;
    Object.defineProperty(prototype, memberName, {
      get: function () {
        return getObserver(this, publicName).current;
      },
      set: function (value) {
        getObserver(this, publicName, value).current = value;
      }
    });

    if (publicName !== memberName) {
      Object.defineProperty(prototype, publicName, {
        get: function () {
          return getObserver(this, publicName).current;
        }
      });
    }
  };
}

function injectReactiveSubscribe(object) {
  object["subscribe"] = function (name, callback) {
    getObserver(this, name).subscribe(callback);
  };

  object["unsubscribe"] = function (name, callback) {
    var _this = this;

    if (!name) {
      keys(getObservers(this)).forEach(function (observerName) {
        _this.unsubscribe(observerName);
      });
      return;
    }

    if (!(name in this)) {
      return;
    }

    getObserver(this, name).unsubscribe(callback);
  };
}
function ReactiveSubscribe(Constructor) {
  var prototype = Constructor.prototype;
  injectReactiveSubscribe(prototype);
}

function reactive(setup) {
  var result = isFunction(setup) ? setup() : setup;
  var reactiveObject = {};
  defineObservers(reactiveObject);
  keys(result).forEach(function (name) {
    var value = result[name];

    if (isObserver(value)) {
      setObserver(reactiveObject, name, value);
      Reactive(name)(reactiveObject, name);
    } else {
      reactiveObject[name] = value;
    }
  });
  injectReactiveSubscribe(reactiveObject);
  return reactiveObject;
}

function adaptReactive(adapter) {
  var _a;

  function data() {
    var _a, _b;

    return (_b = (_a = adapter.data) === null || _a === void 0 ? void 0 : _a.call(adapter)) !== null && _b !== void 0 ? _b : {};
  }

  var instanceRef = {
    current: ((_a = adapter.created) === null || _a === void 0 ? void 0 : _a.call(adapter, data())) || null
  };
  var firstState = null;
  return {
    state: function () {
      var inst = instanceRef.current;

      if (firstState) {
        return firstState;
      }

      if (adapter.state) {
        firstState = adapter.state;
      } else if (inst) {
        var observers_1 = getObservers(inst);
        firstState = keys(observers_1).reduce(function (prev, cur) {
          prev[cur] = observers_1[cur].current;
          return prev;
        }, {});
      }

      return firstState || {};
    },
    instance: function () {
      return instanceRef.current;
    },
    mounted: function () {
      var _a;

      instanceRef.current = ((_a = adapter.mounted) === null || _a === void 0 ? void 0 : _a.call(adapter, data())) || instanceRef.current;
    },
    init: function () {
      var _a;

      (_a = adapter.init) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, data());
    },
    destroy: function () {
      var _a;

      (_a = adapter.destroy) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, data());
    },
    methods: function () {
      return withReactiveMethods(instanceRef, adapter.methods);
    },
    on: function (eventName, listener) {
      var _a;

      (_a = adapter.on) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, eventName, listener);
    },
    off: function (eventName, listener) {
      var _a;

      (_a = adapter.off) === null || _a === void 0 ? void 0 : _a.call(adapter, instanceRef.current, eventName, listener);
    }
  };
}

export { Observer, Reactive, ReactiveSubscribe, adaptReactive, camelize, defineObservers, findTarget, getObserver, getObservers, injectReactiveSubscribe, isFunction, isObject, isObserver, isString, keys, observe, reactive, setObserver, withClassMethods, withReactiveMethods };
//# sourceMappingURL=cfcs.esm.js.map
