import { ExtractNever } from "../core";
import { Observer } from "./Observer";
import { ReactiveSubscribe } from "./ReactiveSubscribe";
declare type ConvertValue<Object extends Record<string, any>> = {
    [Key in keyof Object]: Object[Key] extends Observer<infer Type> ? Type : Object[Key];
};
declare type PickObverser<Object extends Record<string, any>> = ExtractNever<{
    [Key in keyof Object]: Object[Key] extends Observer<infer Type> ? Type : never;
}>;
export declare type ReactiveObject<Object extends Record<string, any>> = ConvertValue<Object> & ReactiveSubscribe<PickObverser<Object>>;
export declare function reactive<Object extends Record<string, any>>(setup: Readonly<Object> | (() => Readonly<Object>)): ReactiveObject<Object>;
export {};
